// Header File
// Created 06/12/2003; 20:48:21
//Fonctions associ aux rackets

void ChangeRacketSpeed (unsigned char item, unsigned short speed);

//Structure BILLE
struct RACKET {
	short xpos, ypos;																	//Coordonnes de la racket
	
	unsigned char size;																//Taille de la racket de 0  3
	unsigned char size_x, size_y;											//Taille en pixel de la racket
	unsigned char size_x2, size_y2;										//Taille en pixel de la racket-1
	
	unsigned char sprite;															//Sprite principal de la racket
	int sprite_anim;																	//Sprite en cours animation
	
	//Animations
	int new_;																					//Changement de racket passage Bonus
	char Tbl_anims[2][2];															//Table d'animation pour arriver  objectif (anim-sens)
	unsigned char Tbl_item;														//Parcours table animations
	
	//Interruption changement de vitesse
	unsigned short speed;															//Vitesse de dplacement
	unsigned char speed_value;												//Coefficient de vitesse
	unsigned short counter_value;											//Counter incrmentations
	unsigned short counter_update_racketpos;					//Update racket pos
	
	//Shadow
	BOOL flag_shadow;																	//Affichage ombre
	
	//Shoot
	BOOL shoot;																				//Autorisation de tir
	unsigned long COUNTER_MISSILE_TIME_SHOOT;					//Temps entre chaque missile
	unsigned char nbrMissile;													//Nombre de missiles
	
	//Colle
	BOOL colle;
	unsigned short COUNTER_BONUS_COLLE;								//Temps en seconde avant de tirer automatiquement
	
	//Extension double raquette
	BOOL double_racket;																//Extension double raquette
	
	//Gestion animation
	BOOL double_racket_anim;
	short double_xpos;																//Coordonne x de l'animation
	char double_dir;																	//Direction de l'animation
	
	unsigned char double_racket_n;										//Item associ
	
	//Uniquement pour les doubles racket
	BOOL isDoubleRacket;															//C'est une double racket
	unsigned char parent;															//Parent
	
	//Bonus fantme
	BOOL ghost;																				//Raquette fantme											
	char ghost_dir;																		//Direction du Ghost
	short ghost_xpos;																	//Coordonne
	BOOL ShowGhost;																		//Afficher Ghost
	BOOL ghost_key;																		//Appuie touche
	
	//Bonus 3 billes
	BOOL Billes_3;																		//3 Billes
	
	BOOL touch;																				//Raquette touch avec Bille
	
	short xpos2;																			//Ancienne valeur de xpos pour variation de vitesse
	
	//Bonus
	//BOOL Bonus;
};

struct RACKET *Racket[8];														//Structure des rackets
static unsigned char nbrRacket=0;
//Existance des rackets
//BOOL Tbl_Rackets [8];
//Taille rackets ANIMS
const unsigned char RACKETS_ANIMS_size [4][6]={{29,29,27,25,0,0},
																							 {31,32,35,37,0,0},
																							 {28,28,28,28,28,28},
																							 {28,28,28,28,28,0}};
//Taille rackets GAME																							 
const unsigned char RACKETS_GAME_size [4]={24,29,37,29};

//Affichage rackets
#define RACKET_ANIM_FREQUENCY						4 //Hz
#define __RACKET_ANIM_FREQUENCY					514
unsigned short __RACKET_ANIM_COUNTER=0;

//Taille des rackets
#define RACKET_SMALL				0
#define RACKET_NORMAL				1
#define RACKET_EXPAND				2
#define RACKET_SHOOT				3

#define RACKET_NEW					4
#define RACKET_DEAD					5

#define RACKET_VARSPEED			7					//Division pour la variation de vitesse

//Variation de vitesse pour la bille
#define RACKET_VARSPEED_FREQUENCY						2.6 //Hz
#define __RACKET_VARSPEED_FREQUENCY					330
unsigned short __RACKET_VARSPEED_COUNTER=0;

//Active tir missile interruption (temps entre chaque tirs)
BOOL StartIntMissiles=FALSE;

//Alloue des blocs de mmoire pour les rackets.
/*void Create_RacketAllocation (void)
{
	nbrRacket=0;
	//memset (Tbl_Rackets,0,8);
	for (int i=0;i<8;i++) Racket [i]=malloc (sizeof (struct RACKET));
}*/

//Dtruit les blocs de mmoire des rackets.
void Destroy_RacketAllocation (void)
{
	for (int i=0;i<nbrRacket;i++) free (Racket[i]);
}

//Cration d'une racket
void NewRacket (short x, short y, unsigned char size, unsigned short speed)
{
	//Dpassement
	if (nbrRacket==8) return;
	
	//Alloue de la mmoire pour la racket
	Racket [nbrRacket]=malloc (sizeof (struct RACKET));
		
	//Arrte interruption animations rackets
	Rackets_anim=FALSE;
	__RACKET_ANIM_COUNTER=0;
	
	//Coordonnes de la raquette
	Racket [nbrRacket]->xpos=Racket [nbrRacket]->xpos2=x; Racket [nbrRacket]->ypos=y;
	
	//Sprite racket
	Racket [nbrRacket]->sprite=size;
	Racket [nbrRacket]->sprite_anim=0;
	Racket [nbrRacket]->flag_shadow=FALSE;
	
	//Taille
	Racket [nbrRacket]->size=size;
	
	//Bonus
	Racket [nbrRacket]->shoot=FALSE;
	Racket [nbrRacket]->colle=FALSE;
	Racket [nbrRacket]->double_racket=FALSE;
	Racket [nbrRacket]->double_racket_anim=FALSE;
	Racket [nbrRacket]->isDoubleRacket=FALSE;
	//Racket [nbrRacket]->Bonus=FALSE;
	Racket [nbrRacket]->ghost=FALSE;
	Racket [nbrRacket]->Billes_3=FALSE;
	Racket [nbrRacket]->touch=FALSE;
		
	//Temps d'attente entre chaque tirs de missile
	Racket [nbrRacket]->COUNTER_MISSILE_TIME_SHOOT=0;
	Racket [nbrRacket]->nbrMissile=0;
	
	//Taille y
	Racket [nbrRacket]->size_y=9;
	Racket [nbrRacket]->size_y2=8;
	
	//Taille x
	Racket [nbrRacket]->size_x=RACKETS_GAME_size [size];
	Racket [nbrRacket]->size_x2=Racket [nbrRacket]->size_x-1;
	
	//Pas d'animations
	Racket [nbrRacket]->new_=-1;
	
	//Vitesse du monstre
	ChangeRacketSpeed (nbrRacket, speed);
	
	nbrRacket++;
	
	//Active interruption animations rackets
	Rackets_anim=TRUE;
	StartIntMissiles=TRUE;
}

//Dessine les rackets
void DrawRackets (void)
{
	short sizey;
	
	for (int i=0;i<nbrRacket;i++)
	{
		//Si dans zone de jeu
		if ((Racket [i]->xpos>=START_X) && ((Racket [i]->xpos+Racket [i]->size_x2)<=GAME_WIDTH2) && (Racket [i]->ypos>=START_Y) && ((Racket [i]->ypos+Racket [i]->size_y2)<=GAME_HEIGHT2))
		{
			sizey=Racket [i]->size_y;
			if (Racket [i]->size>6) sizey=13;
			
			//Shadow 32 premiers pixels sauf mort ou naissance
			if (Racket [i]->flag_shadow && (Racket [i]->size<7))
				DrawSprite32_SHADOW (Racket [i]->xpos+(Racket [i]->size_x/4),Racket [i]->ypos+(Racket [i]->size_y/3),sizey,SPRITE_RACKETS [Racket [i]->sprite][Racket [i]->sprite_anim],ScreenBuffer);
		
			//Dessine les 32 premiers pixels
			FastGraySprite32_MASK_R (Racket [i]->xpos,Racket [i]->ypos,sizey,SPRITE_RACKETS [Racket [i]->sprite][Racket [i]->sprite_anim],ScreenBuffer);
		
			//Reste de 8 pixels si racket>32
			if ((Racket [i]->size==2) || (Racket [i]->size==5))
			{
				//Shadow
				if (Racket [i]->flag_shadow)
					DrawSprite8_SHADOW (Racket [i]->xpos+(Racket [i]->size_x/4)+32,Racket [i]->ypos+(Racket [i]->size_y/3),sizey,SPRITE_RACKETS [Racket [i]->sprite][Racket [i]->sprite_anim]+Rackets_size0,ScreenBuffer);
			
				//Dessine les 8 derniers pixels restant
				FastGraySprite8_MASK_R (Racket [i]->xpos+32,Racket [i]->ypos,sizey,SPRITE_RACKETS [Racket [i]->sprite][Racket [i]->sprite_anim]+Rackets_size0,ScreenBuffer);
			}
		}
	}
}

//Changement taille racket
void ChangeRacket (unsigned char item, unsigned char size)
{
	unsigned char racket_size;
	
	//Si Racket n'existe pas
	if (item>(nbrRacket-1)) return;
	
	//Quitter fonction
	if (size==Racket [item]->size) return;
	
	//Arrte interruption
	StartInt1=FALSE;
	Rackets_anim=FALSE;
	__RACKET_ANIM_COUNTER=0;
	
	//But  aqurir
	Racket [item]->new_=size;
	Racket [item]->Tbl_item=0;
	Racket [item]->sprite_anim=0;
	
	//shoot
	Racket [item]->shoot=FALSE;
	if (size==RACKET_SHOOT) 
	{
		Racket [item]->shoot=TRUE;
		Racket [item]->COUNTER_MISSILE_TIME_SHOOT=0;
	}
	
	//Bonus Colle
	Racket [item]->colle=FALSE;
	Racket [item]->touch=FALSE;
	
	//Bonus Extension double racket
	//Racket [item]->double_racket=FALSE;
	//Racket [nbrRacket]->double_racket_anim=FALSE;
	
	//Table d'animations
	switch (Racket [item]->size)
	{
		//Petit
		case 0:
    	Racket [item]->Tbl_anims [0][0]=4;
    	Racket [item]->Tbl_anims [0][1]=size+3;
    	
    	if (size==1) Racket [item]->Tbl_anims [0][1]=0; 
    break;
    
    //Moyen
    case 1:
    	Racket [item]->Tbl_anims [0][0]=size+3;
    	
			//Moyen->Petit
			if (!size) Racket [item]->Tbl_anims [0][0]=4;
			
			Racket [item]->Tbl_anims [0][1]=0;
		break;
		
		//Grand
		case 2:
			Racket [item]->Tbl_anims [0][0]=5;
			
			switch (size)
			{
				//Grand->Petit
				case 0:
					Racket [item]->Tbl_anims [0][1]=4;
				break;
				
				//Grand->Moyen
				case 1:
					Racket [item]->Tbl_anims [0][1]=0;
				break;
				
				//Grand->Shoot
				case 3:
					Racket [item]->Tbl_anims [0][1]=6;
				break;
			}
		break;
		
		//Shoot
		case 3:
			Racket [item]->Tbl_anims [0][0]=6;
			
			switch (size)
			{
				//Shoot->Petit
				case 0:
					Racket [item]->Tbl_anims [0][1]=4;
				break;
				
				//Shoot->Moyen
				case 1:
					Racket [item]->Tbl_anims [0][1]=0;
				break;
				
				//Shoot->Grand
				case 2:
					Racket [item]->Tbl_anims [0][1]=5;
				break;
			}
		break;
	}
	
	//Table de directions
	//-------------------
	//Moyen->?
	if (Racket [item]->size==1)	Racket [item]->Tbl_anims [1][0]=1;
	
	//?->Moyen
	else if (!Racket [item]->Tbl_anims [0][1]) Racket [item]->Tbl_anims [1][0]=-1;
	
	//2 animations
	else
	{
		Racket [item]->Tbl_anims [1][0]=-1;
		Racket [item]->Tbl_anims [1][1]=1;
	}
	
	//Prparation de l'image de dbut
	//-------------------------------
	if (Racket [item]->Tbl_anims [1][0]==1)
		Racket [item]->sprite_anim=0;
	//Autre direction
	else
	{
		racket_size=Racket [item]->Tbl_anims [0][0];
		
		if ((racket_size==4) || (racket_size==5)) Racket [item]->sprite_anim=3;
		else Racket [item]->sprite_anim=5;
	}
	
	//Prparation sprite principal
	//----------------------------
	Racket [item]->sprite=Racket [item]->Tbl_anims [0][0];
	Racket [item]->size=Racket [item]->Tbl_anims [0][0];
	
	//Taille
	Racket [item]->size_x=RACKETS_ANIMS_size [Racket [item]->sprite-4][Racket [item]->sprite_anim];
	Racket [item]->size_x2=Racket [item]->size_x-1;
	
	//Joue interruption
	Rackets_anim=TRUE;
	StartInt1=TRUE;
}

//Dtruire une raquette
void DestroyRacket (unsigned char item)
{
	//Si correspond  la raquette joueur humain
	if (item==HUMAIN0) HUMAIN0=0xFF;
	
	//Arrte interruption
	StartInt1=FALSE;
	
	DeleteAllBilles (item);
	
	//Libre la mmoire
	free (Racket [item]);
	
	//Dplace liste de pointeurs
	memmove ((void *)(Racket+item),(void *)(Racket+item+1),(nbrRacket-item-1)<<2);
	
	//Racket en moins
	nbrRacket--;
	
	//Restore interruption
	StartInt1=TRUE;
}

//Change la vitesse d'un monstre
void ChangeRacketSpeed (unsigned char item, unsigned short speed)
{
	//Vitesse maximum
	if (speed>200) speed=255;
	
	//Arrte interruption
	StartInt1=FALSE;
	
	Racket [item]->speed=speed;
	Racket [item]->speed_value=0;
	Racket [item]->counter_value=speed*32768/255;
	Racket [item]->counter_update_racketpos=0;
	
	//Restore interruption
	StartInt1=TRUE;
}

//Naissance racket avec animation
void CREATE_ANIM_RACKET_NEW (short x, short y)
{
	//Arrte interruption
	Rackets_anim=FALSE;
	StartInt1=FALSE;
	__RACKET_ANIM_COUNTER=0;
	
	//Crer racket
	NewRacket (x,y,RACKET_NORMAL,DEFAULT_SPEED_RACKETS);
	Racket [nbrRacket-1]->size=8;
	Racket [nbrRacket-1]->sprite=8;
	Racket [nbrRacket-1]->size_x=32;
	Racket [nbrRacket-1]->size_x2=31;
	Racket [nbrRacket-1]->sprite_anim=0;
	Racket [nbrRacket-1]->new_=8;
	
	//Joue interruption
	Rackets_anim=TRUE;
	StartInt1=TRUE;
}

//Naissance racket avec animation
void CREATE_ANIM_RACKET_DEAD (unsigned char item)
{
	//Arrte interruption
	Rackets_anim=FALSE;
	__RACKET_ANIM_COUNTER=0;
	
	Racket [item]->size=7;
	Racket [item]->sprite=7;
	Racket [item]->size_x=32;
	Racket [item]->size_x2=31;
	Racket [item]->sprite_anim=0;
	Racket [item]->new_=7;
	
	//Bonus
	Racket [item]->ghost=FALSE;
	
	//Dtruire Double Racket
	if (Racket [item]->double_racket)
		DestroyRacket (Racket [item]->double_racket_n);
	
	//Joue interruption
	Rackets_anim=TRUE;
}

//Dtruit toutes les rackets
void DestroyAllRackets	(void)
{
	//Parcours rackets
	for (int i=0;i<nbrRacket;i++)
		DestroyRacket (i--);
}	